
//// change these to suit the application ////

#undef  INIT_DAC_RUNNING

//////////////////////////////////////////////

#include "p33Fxxxx.h"
#include "dac.h"
#include "config.h"
#include <string.h>
#include <stdlib.h>

signed short DMA_DACBufferA[DAC_SAMPLES_PER_BUFFER] __attribute__((space(dma)));
signed short DMA_DACBufferB[DAC_SAMPLES_PER_BUFFER] __attribute__((space(dma)));

void pause_dac(unsigned char paused) {
	DAC1CONbits.DACEN = !paused;
}

void init_dac(void) {
	/* DMA Channel 0 set to DAC1LDAT */
	DMA0CONbits.MODE = 2; /* Continuous Mode with Ping-Pong Enabled */
	DMA0CONbits.DIR = 1;  /* Ram-to-Peripheral Data Transfer */
	DMA0PAD = (volatile unsigned int)&DAC1LDAT; /* Point DMA to DAC1LDAT */
	DMA0CNT = DAC_SAMPLES_PER_BUFFER-1;
	DMA0REQ = 79; /* Select DAC1LDAT as DMA Request Source */
	DMA0STA = __builtin_dmaoffset(DMA_DACBufferA);
	DMA0STB = __builtin_dmaoffset(DMA_DACBufferB);
	IFS0bits.DMA0IF = 0; /* Clear DMA Interrupt Flag */
	IEC0bits.DMA0IE = 1; /* Set DMA Interrupt Enable Bit */
	DMA0CONbits.CHEN = 1; /* Enable DMA Channel 0 */

    ACLKCONbits.ASRCSEL = 1;  // set primary oscillator as source for the reference clock
    ACLKCONbits.APSTSCLR = 7; // no clock division
    ACLKCONbits.SELACLK = 0;  // enable auxilliary clock

    DAC1STATbits.LOEN = 1;    // enable left channel output
	DAC1STATbits.LITYPE = 1;  // Left Channel Interrupt if FIFO is Empty
#ifdef SLOW_CLOCK
    DAC1CONbits.DACFDIV = 7;  // divide clock by eight
#else
    DAC1CONbits.DACFDIV = 15; // divide clock by sixteen
#endif
    DAC1CONbits.FORM = 1;     // signed integer

#ifdef INIT_DAC_RUNNING
    DAC1CONbits.DACEN = 1;    // enable DAC
#endif
}

extern signed short* local_playback;
// these don't need to be volatile since they can't change during the interrupt handler
extern unsigned char local_playback_pos, local_playback_used;
extern unsigned char local_playback_rates[LOCAL_BUFFERS];
unsigned char current_playback_rate;

void __attribute__((__interrupt__, no_auto_psv)) _DMA0Interrupt(void) {
  signed short* dest, * src;
  IFS0bits.DMA0IF = 0;
  dest = DMACS1bits.PPST0 ? DMA_DACBufferA : DMA_DACBufferB;

  if( local_playback_used > 0 ) {
    if( local_playback_rates[local_playback_pos] != current_playback_rate ) {
      unsigned char adcs;
      current_playback_rate = local_playback_rates[local_playback_pos];
      switch(current_playback_rate) {
//    case 0:
	  default:
	    adcs = 16;
	    break;
	  case 1:
	    adcs = 24;
	    break;
	  case 2:
	    adcs = 32;
	    break;
	  case 3:
	    adcs = 64;
	    break;
	  }
#ifdef SLOW_CLOCK
      DAC1CONbits.DACFDIV = (adcs >> 1) - 1;  // nominally, divide clock by eight
#else
      DAC1CONbits.DACFDIV = adcs - 1; // nominally, divide clock by sixteen
#endif
    }

    src = local_playback + SAMPLES_PER_BUFFER * (unsigned short)local_playback_pos;
    memcpy(dest, src, SAMPLES_PER_BUFFER * sizeof(unsigned short));
    if( ++local_playback_pos == LOCAL_BUFFERS )
      local_playback_pos = 0;
    --local_playback_used;
  }

  IFS0bits.DMA0IF = 0;
}

unsigned char is_dac_running() {
	return DAC1CONbits.DACEN;
}
